﻿using Spectral1.DATA_ACCESS;
using System;

namespace Spectral1.BUSINESS_LOGIC
{
    public class BL_MIDI
    {
        static public Int32 NoteNameToNumber(string note_name)
        {
            note_name = note_name.ToUpper();
            Int32 note_number = 0;
            Int32 octave_note_id = 0;
            Int32 octave_id = 0;

            if (note_name.StartsWith("C#"))
            {
                octave_note_id = 1;
                octave_id = Convert.ToInt32(note_name.Substring(2));
            }
            else if (note_name.StartsWith("C"))
            {
                octave_note_id = 0;
                octave_id = Convert.ToInt32(note_name.Substring(1));
            }
            else if (note_name.StartsWith("D#"))
            {
                octave_note_id = 3;
                octave_id = Convert.ToInt32(note_name.Substring(2));
            }
            else if (note_name.StartsWith("D"))
            {
                octave_note_id = 2;
                octave_id = Convert.ToInt32(note_name.Substring(1));
            }
            else if (note_name.StartsWith("E"))
            {
                octave_note_id = 4;
                octave_id = Convert.ToInt32(note_name.Substring(1));
            }
            else if (note_name.StartsWith("F#"))
            {
                octave_note_id = 6;
                octave_id = Convert.ToInt32(note_name.Substring(2));
            }
            else if (note_name.StartsWith("F"))
            {
                octave_note_id = 5;
                octave_id = Convert.ToInt32(note_name.Substring(1));
            }
            else if (note_name.StartsWith("G#"))
            {
                octave_note_id = 8;
                octave_id = Convert.ToInt32(note_name.Substring(2));
            }
            else if (note_name.StartsWith("G"))
            {
                octave_note_id = 7;
                octave_id = Convert.ToInt32(note_name.Substring(1));
            }
            else if (note_name.StartsWith("A#"))
            {
                octave_note_id = 10;
                octave_id = Convert.ToInt32(note_name.Substring(2));
            }
            else if (note_name.StartsWith("A"))
            {
                octave_note_id = 9;
                octave_id = Convert.ToInt32(note_name.Substring(1));
            }
            else if (note_name.StartsWith("B"))
            {
                octave_note_id = 11;
                octave_id = Convert.ToInt32(note_name.Substring(1));
            }

            note_number = ((octave_id + 1) * 12) + octave_note_id;

            if((note_number < DA_Spectral.a0_note_number) || (note_number > DA_Spectral.c8_note_number))
            {
                throw new InvalidOperationException("Note is outside module range !");
            }

            return note_number;
        }

        static public string NoteNumberToName(Int32 octave_note_number)
        {
            string name = "";

            switch (octave_note_number)
            {
                case 0:
                    name = "c";
                    break;
                case 1:
                    name = "c#";
                    break;
                case 2:
                    name = "d";
                    break;
                case 3:
                    name = "d#";
                    break;
                case 4:
                    name = "e";
                    break;
                case 5:
                    name = "f";
                    break;
                case 6:
                    name = "f#";
                    break;
                case 7:
                    name = "g";
                    break;
                case 8:
                    name = "g#";
                    break;
                case 9:
                    name = "a";
                    break;
                case 10:
                    name = "a#";
                    break;
                case 11:
                    name = "b";
                    break;
            }

            return name;
        }
    }
}
